// Javascript Document

/* -------------------------------------------------------------
 設定
------------------------------------------------------------- */

// 総合運動場
const fromDays_ground_myTown = 5;	// 町内 → 開始日（日）
const toMonths_ground_myTown = 2;	// 町内 → 終了日（月）

const fromDays_ground_otherTown = 5;	// 町外 → 開始日（日）
const toMonths_ground_otherTown = 1;	// 町外 → 終了日（月）

// その他の施設
const fromDays_other_myTown = 5;	// 町内 → 開始日（日）
const toMonths_other_myTown = 2;	// 町内 → 終了日（月）

const fromDays_other_otherTown = 5;	// 町外 → 開始日（日）
const toMonths_other_otherTown = 1;	// 町外 → 終了日（月）

// 大会等
const fromDays_event_ground = 5;	// 総合運動場 → 開始日（日）
const toMonths_event_ground = 6;	// 総合運動場 → 終了日（月）

const fromDays_event_other = 5;	// その他の施設 → 開始日（日）
const toMonths_event_other = 6;	// その他の施設 → 終了日（月）


// 曜日表示
const ary_week = ['日','月','火','水','木','金','土'];
const ary_week_class = ['sun','mon','tue','wed','thu','fri','sat'];


// -------------------------------------------------------
// 各要素の取得
// -------------------------------------------------------

// 今日の日付（選択した日付）

const ele_selectedDay = document.querySelector('#selectDay');	// 日デートピッカー

const ele_todayView = document.querySelector('#dateToday__view');	// 今日の日付の表示箇所（p）
const ele_today = document.querySelector('#today');	// 今日の日付の表示箇所（span）
const ele_holiday = document.querySelector('#holiday');	// 祭日の表示箇所


// -------------------------------------------------------
// メインのJOB（日付フィールドのセット, 今日・検証の日付の表示, 5日後の表示, 2か月後の表示, 1か月後の表示）
// -------------------------------------------------------

function keyWorks(dateObj) {

	// 今日の日付を日付フィールドにセット
	const str_targetDate = zeroPadDate(dateObj);
	ele_selectedDay.value = str_targetDate;

	// 今日の日付を表示
	ele_today.textContent = getDateStr(dateObj);
	ele_todayView.className = 'dateToday__view';
	ele_todayView.classList.add('week_' + ary_week_class[dateObj.getDay()]);

	// 今日の日付の祭日を表示
	const holidayName = isHoliday(dateObj);
	if(holidayName) {
		ele_holiday.textContent = holidayName;
		ele_todayView.classList.add('holiday');
	}
	else {
		ele_holiday.textContent = '';
		ele_todayView.classList.remove('holiday');
	}


	// -------------------------------------------------------
	// 総合運動場
	// -------------------------------------------------------

	// 申請可能初日の日付を取得・表示（町内）- 5日後 -
	// ---------------------------------------------------------------------
	const ele_view_date_start_groundMyTown = document.querySelector('#date_start--groundMyTown');	// 開始日の表示
	const ele_dateHoliday_start_groundMyTown = document.querySelector('#dateHoliday_start--groundMyTown');	// 祭日の表示
	const ele_date_start_groundMyTown = document.querySelector('#dateStartGroundMyTown');	// 祭日のClassの挿入

	let firstDateGroundMyTown = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_ground_myTown);

	// 休館日の処理
	for (let i = 0 ; i < ary_closedDaysUspG.length; i++) {
		if(zeroPadDate(firstDateGroundMyTown) === ary_closedDaysUspG[i]) {
			firstDateGroundMyTown = new Date(firstDateGroundMyTown.getFullYear(), firstDateGroundMyTown.getMonth(), firstDateGroundMyTown.getDate() + 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_firstDateGroundMyTown = getDateStr(firstDateGroundMyTown);
	ele_view_date_start_groundMyTown.textContent = str_firstDateGroundMyTown;
	ele_view_date_start_groundMyTown.className = 'week_' + ary_week_class[firstDateGroundMyTown.getDay()];

	// 祝日の表示・Classの追加
	const firstDateGroundMyTownHolidayName = isHoliday(firstDateGroundMyTown);
	if(firstDateGroundMyTownHolidayName) {
		ele_dateHoliday_start_groundMyTown.textContent = firstDateGroundMyTownHolidayName;
		ele_date_start_groundMyTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start_groundMyTown.textContent = '';
		ele_date_start_groundMyTown.classList.remove('holiday');
	}


	// 申請可能初日の日付を取得・表示（町外）- 5日後 -
	// ---------------------------------------------------------------------
	const ele_view_date_start_groundOtherTown = document.querySelector('#date_start--groundOtherTown');	// 開始日の表示
	const ele_dateHoliday_start_groundOtherTown = document.querySelector('#dateHoliday_start--groundOtherTown');	// 祭日の表示
	const ele_date_start_groundOtherTown = document.querySelector('#dateStartGroundOtherTown');	// 祭日のClassの挿入

	let firstDateGroundOtherTown = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_ground_otherTown);

	// 休館日の処理
	for (let i = 0 ; i < ary_closedDaysUspG.length; i++) {
		if(zeroPadDate(firstDateGroundOtherTown) === ary_closedDaysUspG[i]) {
			firstDateGroundOtherTown = new Date(firstDateGroundOtherTown.getFullYear(), firstDateGroundOtherTown.getMonth(), firstDateGroundOtherTown.getDate() + 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_firstDateGroundOtherTown = getDateStr(firstDateGroundOtherTown);
	ele_view_date_start_groundOtherTown.textContent = str_firstDateGroundOtherTown;
	ele_view_date_start_groundOtherTown.className = 'week_' + ary_week_class[firstDateGroundOtherTown.getDay()];

	// 祝日の表示・Classの追加
	const firstDateGroundOtherTownHolidayName = isHoliday(firstDateGroundOtherTown);
	if(firstDateGroundOtherTownHolidayName) {
		ele_dateHoliday_start_groundOtherTown.textContent = firstDateGroundOtherTownHolidayName;
		ele_date_start_groundOtherTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start_groundOtherTown.textContent = '';
		ele_date_start_groundOtherTown.classList.remove('holiday');
	}


	// 申請可能最終日の日付を取得・表示（町内）- 2か月後 -
	// ---------------------------------------------------------------------
	const ele_view_date_last_groundMyTown = document.querySelector('#date_end--groundMyTown');	// 開始日の表示
	const ele_dateHoliday_last_groundMyTown = document.querySelector('#dateHoliday_end--groundMyTown');	// 祭日の表示
	const ele_date_last_groundMyTown = document.querySelector('#dateFinalGroundMyTown');	// 祭日のClassの挿入

	// let lastDateGroundMyTown = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + toMonths_ground_myTown);
	let lastDateGroundMyTown = getMonthsLaterDate(dateObj, toMonths_ground_myTown);

	// 休館日の処理
	for (let i = ary_closedDaysUspG.length - 1; i >= 0; i--) {
		if(zeroPadDate(lastDateGroundMyTown) === ary_closedDaysUspG[i]) {
			lastDateGroundMyTown = new Date(lastDateGroundMyTown.getFullYear(), lastDateGroundMyTown.getMonth(), lastDateGroundMyTown.getDate() - 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_finalDateGroundMyTown = getDateStr(lastDateGroundMyTown);
	ele_view_date_last_groundMyTown.textContent = str_finalDateGroundMyTown;
	ele_view_date_last_groundMyTown.className = 'week_' + ary_week_class[lastDateGroundMyTown.getDay()];

	// 祝日の表示・Classの追加
	const lastDateGroundMyTownHolidayName = isHoliday(lastDateGroundMyTown);
	if(lastDateGroundMyTownHolidayName) {
		ele_dateHoliday_last_groundMyTown.textContent = lastDateGroundMyTownHolidayName;
		ele_date_last_groundMyTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_last_groundMyTown.textContent = '';
		ele_date_last_groundMyTown.classList.remove('holiday');
	}


	// 申請可能最終日の日付を取得・表示（町外）- 1か月後 -
	// ---------------------------------------------------------------------
	const ele_view_date_last_groundOtherTown = document.querySelector('#date_end--groundOtherTown');	// 開始日の表示
	const ele_dateHoliday_last_groundOtherTown = document.querySelector('#dateHoliday_end--groundOtherTown');	// 祭日の表示
	const ele_date_last_groundOtherTown = document.querySelector('#dateFinalGroundOtherTown');	// 祭日のClassの挿入

	let lastDateGroundOtherTown = getMonthsLaterDate(dateObj, toMonths_ground_otherTown);

	// 休館日の処理
	for (let i = ary_closedDaysUspG.length - 1; i >= 0; i--) {
		if(zeroPadDate(lastDateGroundOtherTown) === ary_closedDaysUspG[i]) {
			lastDateGroundOtherTown = new Date(lastDateGroundOtherTown.getFullYear(), lastDateGroundOtherTown.getMonth(), lastDateGroundOtherTown.getDate() - 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_finalDateGroundOtherTown = getDateStr(lastDateGroundOtherTown);
	ele_view_date_last_groundOtherTown.textContent = str_finalDateGroundOtherTown;
	ele_view_date_last_groundOtherTown.className = 'week_' + ary_week_class[lastDateGroundOtherTown.getDay()];

	// 祝日の表示・Classの追加
	const lastDateGroundOtherTownHolidayName = isHoliday(lastDateGroundOtherTown);
	if(lastDateGroundOtherTownHolidayName) {
		ele_dateHoliday_last_groundOtherTown.textContent = lastDateGroundOtherTownHolidayName;
		ele_date_last_groundOtherTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_last_groundOtherTown.textContent = '';
		ele_date_last_groundOtherTown.classList.remove('holiday');
	}


	// -------------------------------------------------------
	// その他の施設
	// -------------------------------------------------------

	// 申請可能初日の日付を取得・表示（町内）- 5日後 -
	// ---------------------------------------------------------------------
	const ele_view_date_start_otherMyTown = document.querySelector('#date_start--otherMyTown');	// 開始日の表示
	const ele_dateHoliday_start_otherMyTown = document.querySelector('#dateHoliday_start--otherMyTown');	// 祭日の表示
	const ele_date_start_otherMyTown = document.querySelector('#dateStartOtherMyTown');	// 祭日のClassの挿入

	let firstDateOtherMyTown = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_other_myTown);

	// 休館日の処理
	for (let i = 0 ; i < ary_closedDaysUspO.length; i++) {
		if(zeroPadDate(firstDateOtherMyTown) === ary_closedDaysUspO[i]) {
			firstDateOtherMyTown = new Date(firstDateOtherMyTown.getFullYear(), firstDateOtherMyTown.getMonth(), firstDateOtherMyTown.getDate() + 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_firstDateOtherMyTown = getDateStr(firstDateOtherMyTown);
	ele_view_date_start_otherMyTown.textContent = str_firstDateOtherMyTown;
	ele_view_date_start_otherMyTown.className = 'week_' + ary_week_class[firstDateOtherMyTown.getDay()];

	// 祝日の表示・Classの追加
	const firstDateOtherMyTownHolidayName = isHoliday(firstDateOtherMyTown);
	if(firstDateOtherMyTownHolidayName) {
		ele_dateHoliday_start_otherMyTown.textContent = firstDateOtherMyTownHolidayName;
		ele_date_start_otherMyTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start_otherMyTown.textContent = '';
		ele_date_start_otherMyTown.classList.remove('holiday');
	}


	// 申請可能初日の日付を取得・表示（町外）- 5日後 -
	// ---------------------------------------------------------------------
	const ele_view_date_start_otherOtherTown = document.querySelector('#date_start--otherOtherTown');	// 開始日の表示
	const ele_dateHoliday_start_otherOtherTown = document.querySelector('#dateHoliday_start--otherOtherTown');	// 祭日の表示
	const ele_date_start_otherOtherTown = document.querySelector('#dateStartOtherOtherTown');	// 祭日のClassの挿入

	let firstDateOtherOtherTown = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_other_otherTown);

	// 休館日の処理
	for (let i = 0 ; i < ary_closedDaysUspO.length; i++) {
		if(zeroPadDate(firstDateOtherOtherTown) === ary_closedDaysUspO[i]) {
			firstDateOtherOtherTown = new Date(firstDateOtherOtherTown.getFullYear(), firstDateOtherOtherTown.getMonth(), firstDateOtherOtherTown.getDate() + 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_firstDateOtherOtherTown = getDateStr(firstDateOtherOtherTown);
	ele_view_date_start_otherOtherTown.textContent = str_firstDateOtherOtherTown;
	ele_view_date_start_otherOtherTown.className = 'week_' + ary_week_class[firstDateOtherOtherTown.getDay()];

	// 祝日の表示・Classの追加
	const firstDateOtherOtherTownHolidayName = isHoliday(firstDateOtherOtherTown);
	if(firstDateOtherOtherTownHolidayName) {
		ele_dateHoliday_start_otherOtherTown.textContent = firstDateOtherOtherTownHolidayName;
		ele_date_start_otherOtherTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start_otherOtherTown.textContent = '';
		ele_date_start_otherOtherTown.classList.remove('holiday');
	}


	// 申請可能最終日の日付を取得・表示（町内）- 2か月後 -
	// ---------------------------------------------------------------------
	const ele_view_date_last_otherMyTown = document.querySelector('#date_end--otherMyTown');	// 開始日の表示
	const ele_dateHoliday_last_otherMyTown = document.querySelector('#dateHoliday_end--otherMyTown');	// 祭日の表示
	const ele_date_last_otherMyTown = document.querySelector('#dateFinalOtherMyTown');	// 祭日のClassの挿入

	let lastDateOtherMyTown = getMonthsLaterDate(dateObj, toMonths_other_myTown);

	// 休館日の処理
	for (let i = ary_closedDaysUspO.length - 1; i >= 0; i--) {
		if(zeroPadDate(lastDateOtherMyTown) === ary_closedDaysUspO[i]) {
			lastDateOtherMyTown = new Date(lastDateOtherMyTown.getFullYear(), lastDateOtherMyTown.getMonth(), lastDateOtherMyTown.getDate() - 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_finalDateOtherMyTown = getDateStr(lastDateOtherMyTown);
	ele_view_date_last_otherMyTown.textContent = str_finalDateOtherMyTown;
	ele_view_date_last_otherMyTown.className = 'week_' + ary_week_class[lastDateOtherMyTown.getDay()];

	// 祝日の表示・Classの追加
	const lastDateOtherMyTownHolidayName = isHoliday(lastDateOtherMyTown);
	if(lastDateOtherMyTownHolidayName) {
		ele_dateHoliday_last_otherMyTown.textContent = lastDateOtherMyTownHolidayName;
		ele_date_last_otherMyTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_last_otherMyTown.textContent = '';
		ele_date_last_otherMyTown.classList.remove('holiday');
	}


	// 申請可能最終日の日付を取得・表示（町外）- 1か月後 -
	// ---------------------------------------------------------------------
	const ele_view_date_last_otherOtherTown = document.querySelector('#date_end--otherOtherTown');	// 開始日の表示
	const ele_dateHoliday_last_otherOtherTown = document.querySelector('#dateHoliday_end--otherOtherTown');	// 祭日の表示
	const ele_date_last_otherOtherTown = document.querySelector('#dateFinalOtherOtherTown');	// 祭日のClassの挿入

	let lastDateOtherOtherTown = getMonthsLaterDate(dateObj, toMonths_other_otherTown);

	// 休館日の処理
	for (let i = ary_closedDaysUspO.length - 1; i >= 0; i--) {
		if(zeroPadDate(lastDateOtherOtherTown) === ary_closedDaysUspO[i]) {
			lastDateOtherOtherTown = new Date(lastDateOtherOtherTown.getFullYear(), lastDateOtherOtherTown.getMonth(), lastDateOtherOtherTown.getDate() - 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_finalDateOtherOtherTown = getDateStr(lastDateOtherOtherTown);
	ele_view_date_last_otherOtherTown.textContent = str_finalDateOtherOtherTown;
	ele_view_date_last_otherOtherTown.className = 'week_' + ary_week_class[lastDateOtherOtherTown.getDay()];

	// 祝日の表示・Classの追加
	const lastDateOtherOtherTownHolidayName = isHoliday(lastDateOtherOtherTown);
	if(lastDateOtherOtherTownHolidayName) {
		ele_dateHoliday_last_otherOtherTown.textContent = lastDateOtherOtherTownHolidayName;
		ele_date_last_otherOtherTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_last_otherOtherTown.textContent = '';
		ele_date_last_otherOtherTown.classList.remove('holiday');
	}


	// -------------------------------------------------------
	// 大会等の行事
	// -------------------------------------------------------

	// 申請可能初日の日付を取得・表示（総合運動場）- 5日後 -
	// ---------------------------------------------------------------------
	const ele_view_date_start_eventGround = document.querySelector('#date_start--eventGround');	// 開始日の表示
	const ele_dateHoliday_start_eventGround = document.querySelector('#dateHoliday_start--eventGround');	// 祭日の表示
	const ele_date_start_eventGround = document.querySelector('#dateStartEventGround');	// 祭日のClassの挿入

	let firstDateEventGround = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_event_ground);

	// 休館日の処理
	for (let i = 0 ; i < ary_closedDaysUspG.length; i++) {
		if(zeroPadDate(firstDateEventGround) === ary_closedDaysUspG[i]) {
			firstDateEventGround = new Date(firstDateEventGround.getFullYear(), firstDateEventGround.getMonth(), firstDateEventGround.getDate() + 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_firstDateEventGround = getDateStr(firstDateEventGround);
	ele_view_date_start_eventGround.textContent = str_firstDateEventGround;
	ele_view_date_start_eventGround.className = 'week_' + ary_week_class[firstDateEventGround.getDay()];

	// 祝日の表示・Classの追加
	const firstDateEventGroundHolidayName = isHoliday(firstDateEventGround);
	if(firstDateEventGroundHolidayName) {
		ele_dateHoliday_start_eventGround.textContent = firstDateEventGroundHolidayName;
		ele_date_start_eventGround.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start_eventGround.textContent = '';
		ele_date_start_eventGround.classList.remove('holiday');
	}


	// 申請可能初日の日付を取得・表示（その他の施設）- 5日後 -
	// ---------------------------------------------------------------------
	const ele_view_date_start_eventOther = document.querySelector('#date_start--eventOther');	// 開始日の表示
	const ele_dateHoliday_start_eventOther = document.querySelector('#dateHoliday_start--eventOther');	// 祭日の表示
	const ele_date_start_eventOther = document.querySelector('#dateStarteventOther');	// 祭日のClassの挿入

	let firstDateEventOther = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_event_other);

	// 休館日の処理
	for (let i = 0 ; i < ary_closedDaysUspO.length; i++) {
		if(zeroPadDate(firstDateEventOther) === ary_closedDaysUspO[i]) {
			firstDateEventOther = new Date(firstDateEventOther.getFullYear(), firstDateEventOther.getMonth(), firstDateEventOther.getDate() + 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_firstDateEventOther = getDateStr(firstDateEventOther);
	ele_view_date_start_eventOther.textContent = str_firstDateEventOther;
	ele_view_date_start_eventOther.className = 'week_' + ary_week_class[firstDateEventOther.getDay()];

	// 祝日の表示・Classの追加
	const firstDateEventOtherHolidayName = isHoliday(firstDateEventOther);
	if(firstDateEventOtherHolidayName) {
		ele_dateHoliday_start_eventOther.textContent = firstDateEventOtherHolidayName;
		ele_date_start_eventOther.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start_eventOther.textContent = '';
		ele_date_start_eventOther.classList.remove('holiday');
	}


	// 申請可能最終日の日付を取得・表示（総合運動場）- 6か月後 -
	// ---------------------------------------------------------------------
	const ele_view_date_last_eventGround = document.querySelector('#date_end--eventGround');	// 開始日の表示
	const ele_dateHoliday_last_eventGround = document.querySelector('#dateHoliday_end--eventGround');	// 祭日の表示
	const ele_date_last_eventGround = document.querySelector('#dateFinalEventGround');	// 祭日のClassの挿入

	let lastDateEventGround = getMonthsLaterDate(dateObj, toMonths_event_ground);

	// 休館日の処理
	for (let i = ary_closedDaysUspG.length - 1; i >= 0; i--) {
		if(zeroPadDate(lastDateEventGround) === ary_closedDaysUspG[i]) {
			lastDateEventGround = new Date(lastDateEventGround.getFullYear(), lastDateEventGround.getMonth(), lastDateEventGround.getDate() - 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_finalDateEventGround = getDateStr(lastDateEventGround);
	ele_view_date_last_eventGround.textContent = str_finalDateEventGround;
	ele_view_date_last_eventGround.className = 'week_' + ary_week_class[lastDateEventGround.getDay()];

	// 祝日の表示・Classの追加
	const lastDateEventGroundHolidayName = isHoliday(lastDateEventGround);
	if(lastDateEventGroundHolidayName) {
		ele_dateHoliday_last_eventGround.textContent = lastDateEventGroundHolidayName;
		ele_date_last_eventGround.classList.add('holiday');
	}
	else {
		ele_dateHoliday_last_eventGround.textContent = '';
		ele_date_last_eventGround.classList.remove('holiday');
	}


	// 申請可能最終日の日付を取得・表示（その他の施設）- 6か月後 -
	// ---------------------------------------------------------------------
	const ele_view_date_last_eventOther = document.querySelector('#date_end--eventOther');	// 開始日の表示
	const ele_dateHoliday_last_eventOther = document.querySelector('#dateHoliday_end--eventOther');	// 祭日の表示
	const ele_date_last_eventOther = document.querySelector('#dateFinalEventOther');	// 祭日のClassの挿入

	let lastDateEventOther = getMonthsLaterDate(dateObj, toMonths_event_other);

	// 休館日の処理
	for (let i = ary_closedDaysUspO.length - 1; i >= 0; i--) {
		if(zeroPadDate(lastDateEventOther) === ary_closedDaysUspO[i]) {
			lastDateEventOther = new Date(lastDateEventOther.getFullYear(), lastDateEventOther.getMonth(), lastDateEventOther.getDate() - 1);
		}
	}

	// 日付の表示・曜日のClassを追加
	const str_finalDateEventOther = getDateStr(lastDateEventOther);
	ele_view_date_last_eventOther.textContent = str_finalDateEventOther;
	ele_view_date_last_eventOther.className = 'week_' + ary_week_class[lastDateEventOther.getDay()];

	// 祝日の表示・Classの追加
	const lastDateEventOtherHolidayName = isHoliday(lastDateEventOther);
	if(lastDateEventOtherHolidayName) {
		ele_dateHoliday_last_eventOther.textContent = lastDateEventOtherHolidayName;
		ele_date_last_eventOther.classList.add('holiday');
	}
	else {
		ele_dateHoliday_last_eventOther.textContent = '';
		ele_date_last_eventOther.classList.remove('holiday');
	}

}

/* -------------------------------------------------------------
 メイン機能
------------------------------------------------------------- */

// 今日の日付オブジェクトを取得
const today = new Date();
// ターゲットの日付オブジェクト
let target_date = today;


// メインのJOB（読み込み時）
keyWorks(target_date);



/* -------------------------------------------------------------
 日付を変更して検証
------------------------------------------------------------- */

// デートピッカー変更時（検証用）
ele_selectedDay.addEventListener('change', function(){

	// デートピッカーで選択された日付（yyyy-mm-dd）
	const str_selectDay = ele_selectedDay.value;

	// 選択された日付のオブジェクトを生成
	target_date = new Date(str_selectDay);

	// メインの
	keyWorks(target_date);

	// 検証中の表示（classの追加）
	if(!ele_today.classList.contains('underVerification')) {
		ele_today.classList.add('underVerification');
	}

});



/* -------------------------------------------------------------
 参考データ
------------------------------------------------------------- */

// 祭日
for (let i = 0; i < ary_holidays.length; i++) {
	const str_date = ary_holidays[i][0] + "　" + ary_holidays[i][1];
	const listItem = document.createElement('li');
	listItem.classList.add('listItem' + (i + 1));
	listItem.textContent = '[' + i + '] ' + str_date;
	const ele_list = document.querySelector('#holidayList');
	ele_list.append(listItem);
}

// その他の施設
for (let i = 0; i < ary_closedDaysUspO.length; i++) {
	const str_date = ary_closedDaysUspO[i];
	const listItem = document.createElement('li');
	listItem.classList.add('listItem' + (i + 1));
	listItem.textContent = '[' + i + '] ' + str_date;
	const ele_list = document.querySelector('#closedDaysOtherList');
	ele_list.append(listItem);
}

// 総合運動場
for (let i = 0; i < ary_closedDaysUspG.length; i++) {
	const str_date = ary_closedDaysUspG[i];
	const listItem = document.createElement('li');
	listItem.classList.add('listItem' + (i + 1));
	listItem.textContent = '[' + i + '] ' + str_date;
	const ele_list = document.querySelector('#closedDaysGroundList');
	ele_list.append(listItem);
}




// /* -------------------------------------------------------------
//  デートピッカーの表示・非表示を切り替える
// ------------------------------------------------------------- */

// const ele_calendarButton = document.querySelector('#calendarButton');
// const ele_verificationBlockSelector = document.querySelector('#verificationBlockSelector');

// ele_calendarButton.addEventListener('click', function(){

// 	ele_verificationBlockSelector.classList.toggle('inactive');

// 	// メインの
// 	keyWorks(new Date());

// 	// 検証中の表示（classの追加）
// 	if(ele_today.classList.contains('underVerification')) {
// 		ele_today.classList.remove('underVerification');
// 	}

// });


// /* -------------------------------------------------------------
//  表示施設の切り替え
// ------------------------------------------------------------- */

const ary_choiceFacilityLink = document.querySelectorAll('.choiceFacility__item a');
const ary_choiceFacility = document.querySelectorAll('.choiceFacility__item');
// console.log(ary_choiceFacilityLink);

for (let i = 0; i < ary_choiceFacilityLink.length; i++) {
	const ele = ary_choiceFacilityLink[i];
	console.log(ele);

	ele.addEventListener('click', function(event) {
		event.preventDefault();
		const hrefValue = this.getAttribute('href');
		const ary_facility = document.querySelectorAll('.facility');

		for (let i = 0; i < ary_facility.length; i++) {
			const ele = ary_facility[i];
			ele.classList.remove('active');

		}
		document.querySelector(hrefValue).classList.add('active');

		for (let i = 0; i < ary_choiceFacility.length; i++) {
			const ele = ary_choiceFacility[i];
			console.log(ele);
			ele.classList.remove('active');
		}
		this.parentElement.classList.add('active');

	},false)

}

// ary_choiceFacilityLink.addEventListener('click', function() {
// 	console.log(this.getAttribute('href'));

// },false)

