// Javascript Document

/* -------------------------------------------------------------
 設定
------------------------------------------------------------- */

const fromDays_hall = 10;	// 5日前から
const fromDays_other = 0;	// 0日前から
const toMonths_hall = 6;	// 6か月後まで（町内）
const toMonths_other = 2;	// 2か月後まで（町外）

const ary_week = ['日','月','火','水','木','金','土'];
const ary_week_class = ['sun','mon','tue','wed','thu','fri','sat'];


/* -------------------------------------------------------------
 ユーザー関数
------------------------------------------------------------- */

// // nヶ月前後の年月日を取得する（日付オブジェクトを指定）
// function getMonthsLaterDate(date, addMonth) {	// date: 基準の日付オブジェクト, addMonth: 何か月後か[n]
// 	// const laterDate = new Date(date);
// 	const laterDate_year = date.getFullYear();
// 	const laterDate_month = date.getMonth() + addMonth;
// 	const laterDate_day = date.getDate();
// 	const lastDay = getEndOfMonth(laterDate_year,laterDate_month + 1);

// 	if(laterDate_day > lastDay)  {
// 		newDay = lastDay;
// 	}
// 	else  {
// 		newDay = laterDate_day;
// 	}

// 	const newDate = new Date(laterDate_year, laterDate_month, newDay);
// 	return newDate;

// }

// // 指定日の月末を取得（日付オブジェクトを指定）
// function getEndMonthDate(dateObj) {
// 	dateObj.setMonth(dateObj.getMonth()+1, 0);
// 	return dateObj;
// }

// // 今月の月末日を取得
// // ※次月の0日目＝今月の末日になる
// function getEndOfMonth(year,month) {
// 	const endDate = new Date(year,month,0);
// 	return endDate.getDate();
// }

// // 日付オブジェクトから「yyyy年mm月dd日（日～土）」形式の文字列をl取得
// function getDateStr(date) {
// 	const targetDate = date;
// 	const targetDate_year = targetDate.getFullYear();
// 	const targetDate_month = targetDate.getMonth() + 1;
// 	const targetDate_date = targetDate.getDate();
// 	const str_targetDate = targetDate_year + '年' + String(targetDate_month).padStart(2, '0') + '月' + String(targetDate_date).padStart(2, '0') + '日（' + ary_week[targetDate.getDay()] + '）';
// 	return str_targetDate;
// }

// // 指定日後の日付を取得・表示
// function setFirstDate(objDate, later, ary_ele) {
// 	const firstDate = new Date(objDate.getFullYear(), objDate.getMonth(), objDate.getDate() + later);
// 	const str_firstDate = getDateStr(firstDate);
// 	ary_ele[0].textContent = str_firstDate;
// 	// ary_ele[1].textContent = str_firstDate;
// 	ary_ele[0].className = 'week_' + ary_week_class[firstDate.getDay()];
// 	// ary_ele[1].className = 'week_' + ary_week_class[firstDate.getDay()];
// }

// // 指定か月後の日付を取得・表示
// function setLaterDate(objDate, later, ele) {
// 	const finalDate = getMonthsLaterDate(objDate, later);
// 	const str_finalDate = getDateStr(finalDate);
// 	ele.textContent = str_finalDate;
// 	ele.className = 'week_' + ary_week_class[finalDate.getDay()];
// }

// // 指定か月後の末日の日付を取得・表示
// function setLaterEndDate(objDate, later, ele) {
// 	const finalDate = getMonthsLaterDate(objDate, later);
// 	const finalEndMonthDate = getEndMonthDate(finalDate);
// 	const str_finalEndMonthDate = getDateStr(finalEndMonthDate);
// 	ele.textContent = str_finalEndMonthDate;
// 	ele.className = 'week_' + ary_week_class[finalEndMonthDate.getDay()];
// }

// // 日付オブジェクトから日付文字列を生成（yyyy-mm-dd）
// function zeroPadDate(dateObj) {
// 	const str_zeroPadData = dateObj.getFullYear() + '-' + String(dateObj.getMonth() + 1).padStart(2,'0') + '-'  + String(dateObj.getDate()).padStart(2,'0');
// 	return str_zeroPadData;
// }

// // 祭日を判定、祭日名を取得
// function isHoliday(dateObj, aryHoliday = ary_holidays) {	// 日付オブジェクト, 祭日のデータ（配列）省略時はary_holidays

// 	for(i = 0; i < aryHoliday.length; i++ ) {
// 		if(zeroPadDate(dateObj) == aryHoliday[i][0]) {
// 			return aryHoliday[i][1];
// 		}
// 	}
// 	return false;

// }


// メインのJOB（日付フィールドのセット, 今日・検証の日付の表示, ホールの表示, その他の表示）
function keyWorks(dateObj) {

	// 今日の日付を日付フィールドにセット
	const str_targetDate = zeroPadDate(dateObj);
	ele_selectedDay.value = str_targetDate;

	// 今日の日付を表示
	ele_today.textContent = getDateStr(dateObj);
	ele_todayView.className = 'dateToday__view';
	ele_todayView.classList.add('week_' + ary_week_class[dateObj.getDay()]);

	// 祭日を表示
	const holidayName = isHoliday(dateObj);
	if(holidayName) {
		ele_holiday.textContent = holidayName;
		ele_todayView.classList.add('holiday');
	}
	else {
		ele_holiday.textContent = '';
		ele_todayView.classList.remove('holiday');
	}


	// 今日の10日後の日付を取得・表示
	// setFirstDate(dateObj, fromDays_hall, [ele_view_date__start__hall]);
	let firstDate = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_hall);

	for (let i = 0 ; i < ary_closedDays.length; i++) {
		if(zeroPadDate(firstDate) === ary_closedDays[i]) {
			firstDate = new Date(firstDate.getFullYear(), firstDate.getMonth(), firstDate.getDate() + 1);
		}
	}

	const str_firstDate = getDateStr(firstDate);
	ele_view_date__start__hall.textContent = str_firstDate;
	ele_view_date__start__hall.className = 'week_' + ary_week_class[firstDate.getDay()];
	// ele_view_date__start__hall.classList.add('week_' + ary_week_class[firstDate.getDay()]);


	const firstDateHallHolidayName = isHoliday(firstDate);
	if(firstDateHallHolidayName) {
		ele_dateHoliday_start__hall.textContent = firstDateHallHolidayName;
		ele_dataStartHall.classList.add('holiday');
		// ele_dateHoliday_startOtherTown.textContent = firstDateHallHolidayName;
		// ele_dateStartOtherTown.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start__hall.textContent = '';
		ele_dataStartHall.classList.remove('holiday');
		// ele_dateHoliday_startOtherTown.textContent = '';
		// ele_dateStartOtherTown.classList.remove('holiday');
	}


	// 今日を基準に6か月後の末日の日付を取得・表示
	// setLaterDate(today, toMonths_hall, ele_view_date__end__hall);
	// setLaterEndDate(dateObj, toMonths_hall, ele_view_date__end__hall);

	const finalDateHall = getMonthsLaterDate(dateObj, toMonths_hall);
	let finalEndMonthDateHall = getEndMonthDate(finalDateHall);

	// const finalDate = getMonthsLaterDate(objDate, later);
	// const finalEndMonthDate = getEndMonthDate(finalDate);

	// const str_finalEndMonthDate = getDateStr(finalEndMonthDate);
	// ele.textContent = str_finalEndMonthDate;
	// ele.className = 'week_' + ary_week_class[finalEndMonthDate.getDay()];


	for (let i = ary_closedDays.length - 1; i >= 0; i--) {
		if(zeroPadDate(finalEndMonthDateHall) === ary_closedDays[i]) {
			finalEndMonthDateHall = new Date(finalEndMonthDateHall.getFullYear(), finalEndMonthDateHall.getMonth(), finalEndMonthDateHall.getDate() - 1);
		}
	}

	const str_finalEndMonthDateHall = getDateStr(finalEndMonthDateHall);
	ele_view_date__end__hall.textContent = str_finalEndMonthDateHall;
	ele_dateFinalHall.className = 'week_' + ary_week_class[finalEndMonthDateHall.getDay()];

	const finalDateHolidayNameHall = isHoliday(finalEndMonthDateHall);
	if(finalDateHolidayNameHall) {
		ele_dateHoliday_finalHall.textContent = finalDateHolidayNameHall;
		ele_dateFinalHall.classList.add('holiday');
	}
	else {
		ele_dateHoliday_finalHall.textContent = '';
		ele_dateFinalHall.classList.remove('holiday');
	}


	// 今日の0日後の日付を取得・表示
	// setFirstDate(dateObj, fromDays_other, [ele_view_date__start__other]);

	// 今日の0日後の日付を取得・表示
	// setFirstDate(dateObj, fromDays_hall, [ele_view_date__start__hall]);
	let firstDateOther = new Date(dateObj.getFullYear(), dateObj.getMonth(), dateObj.getDate() + fromDays_other);

	for (let i = 0 ; i < ary_closedDays.length; i++) {
		if(zeroPadDate(firstDateOther) === ary_closedDays[i]) {
			firstDateOther = new Date(firstDateOther.getFullYear(), firstDateOther.getMonth(), firstDateOther.getDate() + 1);
		}
	}

	const str_firstDateOther = getDateStr(firstDateOther);
	ele_view_date__start__other.textContent = str_firstDateOther;
	ele_view_date__start__other.className = 'week_' + ary_week_class[firstDateOther.getDay()];


	const firstDateOtherHolidayName = isHoliday(firstDateOther);
	if(firstDateOtherHolidayName) {
		ele_dateHoliday_start__other.textContent = firstDateOtherHolidayName;
		ele_dataStartOther.classList.add('holiday');
	}
	else {
		ele_dateHoliday_start__other.textContent = '';
		ele_dataStartOther.classList.remove('holiday');
	}


	// 今日を基準に6か月後の末日の日付を取得・表示
	// setLaterDate(today, toMonths_other, ele_view_date__final__other);
	// setLaterEndDate(dateObj, toMonths_other, ele_view_date__final__other);

	const finalDateOther = getMonthsLaterDate(dateObj, toMonths_other);
	let finalEndMonthDateOther = getEndMonthDate(finalDateOther);


	for (let i = ary_closedDays.length - 1; i >= 0; i--) {
		if(zeroPadDate(finalEndMonthDateOther) === ary_closedDays[i]) {
			finalEndMonthDateOther = new Date(finalEndMonthDateOther.getFullYear(), finalEndMonthDateOther.getMonth(), finalEndMonthDateOther.getDate() - 1);
		}
	}

	const str_finalEndMonthDateOther = getDateStr(finalEndMonthDateOther);
	ele_view_date__end__other.textContent = str_finalEndMonthDateOther;
	ele_dateFinalOther.className = 'week_' + ary_week_class[finalEndMonthDateOther.getDay()];

	const finalDateHolidayNameOther = isHoliday(finalEndMonthDateOther);
	if(finalDateHolidayNameOther) {
		ele_dateHoliday_finalOther.textContent = finalDateHolidayNameOther;
		ele_dateFinalOther.classList.add('holiday');
	}
	else {
		ele_dateHoliday_finalOther.textContent = '';
		ele_dateFinalOther.classList.remove('holiday');
	}

}

/* -------------------------------------------------------------
 
------------------------------------------------------------- */

// 各要素を取得
const ele_todayView = document.querySelector('#dateToday__view');	// 今日の日付の表示箇所（p）
const ele_today = document.querySelector('#today');	// 今日の日付の表示箇所（span）
const ele_holiday = document.querySelector('#holiday');	// 祭日の表示箇所

const ele_selectedDay = document.querySelector('#selectDay');	// 日デートピッカー
const ele_view_selectedDay = document.querySelector('#view_selectedDay');	// 選択された日付の表示箇所

const ele_view_date__start__hall = document.querySelector('#date_start--hall');	// 申請可能日の表示箇所
const ele_view_date__end__hall = document.querySelector('#date_end--hall');	// 申請可能日の表示箇所

const ele_dataStartHall = document.querySelector('#dataStartHall');	// 申請可能日の表示箇所（td）
const ele_dateHoliday_start__hall = document.querySelector('#dateHoliday_start--hall');	// 申請可能日の表示箇所（span）

const ele_dateHoliday_start__other = document.querySelector('#dateHoliday_start--other');
const ele_dataStartOther = document.querySelector('#dataStartOther');

const ele_view_date__start__other = document.querySelector('#date_start--other');	// 申請可能日の表示箇所
const ele_view_date__final__other = document.querySelector('#date_end--other');	// 申請可能日の表示箇所
// const ele_lastModify = document.querySelector('#lastModify');	// 最終更新日の表示箇所

const ele_dateFinalHall = document.querySelector('#dateFinalHall');
const ele_dateHoliday_finalHall = document.querySelector('#dateHoliday_end--hall');

const ele_dateFinalOther = document.querySelector('#dateFinalOther');
const ele_dateHoliday_finalOther = document.querySelector('#dateHoliday_end--other');
const ele_view_date__end__other = document.querySelector('#date_end--other');

// 今日の日付を取得できるnew Dateを格納
const today = new Date();
// ターゲットの日付オブジェクト
let target_date = today;

// メインのJOB
keyWorks(target_date);

/* -------------------------------------------------------------
日付を変更して検証
------------------------------------------------------------- */

// デートピッカー変更時（検証用）
ele_selectedDay.addEventListener('change', function(){

	// デートピッカーで選択された日付（yyyy-mm-dd）
	const str_selectDay = ele_selectedDay.value;

	// 選択された日付のオブジェクトを生成
	target_date = new Date(str_selectDay);

	// メインの
	keyWorks(target_date);

	// 検証中の表示（classの追加）
	if(!ele_today.classList.contains('underVerification')) {
		ele_today.classList.add('underVerification');
	}

});



// 祭日・休館日一覧
// ---------------------------------------------------------------------

// 祭日
for (let i = 0; i < ary_holidays.length; i++) {
	const str_date = ary_holidays[i][0] + "　" + ary_holidays[i][1];
	const listItem = document.createElement('li');
	listItem.classList.add('listItem' + (i + 1));
	listItem.textContent = '[' + i + '] ' + str_date;
	const ele_list = document.querySelector('#holidayList');
	ele_list.append(listItem);
}

// 休館日
for (let i = 0; i < ary_closedDays.length; i++) {
	const str_date = ary_closedDays[i];
	const listItem = document.createElement('li');
	listItem.classList.add('listItem' + (i + 1));
	listItem.textContent = '[' + i + '] ' + str_date;
	const ele_list = document.querySelector('#closedDaysList');
	ele_list.append(listItem);
}



// /* -------------------------------------------------------------
//  デートピッカーの表示・非表示を切り替える
// ------------------------------------------------------------- */

// const ele_calendarButton = document.querySelector('#calendarButton');
// const ele_verificationBlockSelector = document.querySelector('#verificationBlockSelector');

// ele_calendarButton.addEventListener('click', function(){

// 	ele_verificationBlockSelector.classList.toggle('inactive');
// 	ele_calendarButton.classList.toggle('open');

// 	// メインの
// 	keyWorks(today);

// 	// 検証中の表示（classの追加）
// 	if(ele_today.classList.contains('underVerification')) {
// 		ele_today.classList.remove('underVerification');
// 	}

// });


