// Javascript Document

/* -------------------------------------------------------------
 ユーザー関数
------------------------------------------------------------- */

// nヶ月前後の年月日を取得する（日付を個別に指定）
function getAddMonthDate(year,month,day,add) {
	const addMonth = month + add;
	const endDate = getEndOfMonth(year,addMonth);//add分を加えた月の最終日を取得

	// 引数で渡された日付がnヶ月後の最終日より大きければ日付を次月最終日に合わせる
	// 5/31→6/30のように応当日が無い場合に必要
	if(day > endDate) {
		day = endDate;
	}
	else {
		day = day;
		// day = day - 1;
	}

	const addMonthDate = new Date(year,addMonth - 1,day);
	return addMonthDate;
}

// nヶ月前後の年月日を取得する（日付オブジェクトを指定）
function getMonthsLaterDate(date, addMonth) {	// date: 基準の日付オブジェクト, addMonth: 何か月後か[n]
	// const laterDate = new Date(date);
	const laterDate_year = date.getFullYear();
	const laterDate_month = date.getMonth() + addMonth;
	const laterDate_day = date.getDate();
	const lastDay = getEndOfMonth(laterDate_year,laterDate_month + 1);

	if(laterDate_day > lastDay)  {
		newDay = lastDay;
	}
	else  {
		newDay = laterDate_day;
	}

	const newDate = new Date(laterDate_year, laterDate_month, newDay);
	return newDate;

}

// 指定日の月末を取得（日付オブジェクトを指定）
function getEndMonthDate(dateObj) {
	dateObj.setMonth(dateObj.getMonth()+1, 0);
	return dateObj;
}

// 今月の月末日を取得
// ※次月の0日目＝今月の末日になる
function getEndOfMonth(year,month) {
	const endDate = new Date(year,month,0);
	return endDate.getDate();
}

// 日付オブジェクトから「yyyy年mm月dd日（日～土）」形式の文字列をl取得
function getDateStr(date) {
	const targetDate = date;
	const targetDate_year = targetDate.getFullYear();
	const targetDate_month = targetDate.getMonth() + 1;
	const targetDate_date = targetDate.getDate();
	const str_targetDate = targetDate_year + '年' + String(targetDate_month).padStart(2, '0') + '月' + String(targetDate_date).padStart(2, '0') + '日（' + ary_week[targetDate.getDay()] + '）';
	return str_targetDate;
}

// 指定日後の日付を取得・表示
function setFirstDate(objDate, later, ary_ele) {
	const firstDate = new Date(objDate.getFullYear(), objDate.getMonth(), objDate.getDate() + later);
	const str_firstDate = getDateStr(firstDate);
	ary_ele[0].textContent = str_firstDate;
	ary_ele[1].textContent = str_firstDate;
	ary_ele[0].className = 'week_' + ary_week_class[firstDate.getDay()];
	ary_ele[1].className = 'week_' + ary_week_class[firstDate.getDay()];
}

// 指定日数後の日付オブジェクトを取得
function daysLater(objDate, later) {
	const laterDate = new Date(objDate.getFullYear(), objDate.getMonth(), objDate.getDate() + later);
	return laterDate;
}

// 指定か月後の日付を取得・表示
function setLaterDate(objDate, later, ele) {
	const finalDate = getMonthsLaterDate(objDate, later);
	const str_finalDate = getDateStr(finalDate);
	ele.textContent = str_finalDate;
	ele.className = 'week_' + ary_week_class[finalDate.getDay()];
}

// function monthLater(objDate, later) {
// 	const laterMonthday = getMonthsLaterDate(objDate, later);
// }

// 日付オブジェクトから日付文字列を生成（yyyy-mm-dd）
function zeroPadDate(dateObj) {
	const str_zeroPadData = dateObj.getFullYear() + '-' + String(String(dateObj.getMonth() + 1).padStart(2,'0')) + '-'  + String(String(dateObj.getDate())).padStart(2,'0');
	return str_zeroPadData;
}

// 祭日を判定、祭日名を取得
function isHoliday(dateObj, aryHoliday = ary_holidays) {	// 日付オブジェクト, 祭日のデータ（配列）省略時はary_holidays

	for(i = 0; i < aryHoliday.length; i++ ) {
		if(zeroPadDate(dateObj) == aryHoliday[i][0]) {
			return aryHoliday[i][1];
		}
	}
	return false;

}



/* -------------------------------------------------------------
 デートピッカーの表示・非表示を切り替える
------------------------------------------------------------- */

const ele_calendarButton = document.querySelector('#calendarButton');
const ele_verificationBlockSelector = document.querySelector('#verificationBlockSelector');

ele_calendarButton.addEventListener('click', function(){

	ele_verificationBlockSelector.classList.toggle('inactive');
	ele_calendarButton.classList.toggle('open');

	// メインの
	keyWorks(today);

	// 検証中の表示（classの追加）
	if(ele_today.classList.contains('underVerification')) {
		ele_today.classList.remove('underVerification');
	}

});
